#ifndef __DM_ERRORS_H__
#define __DM_ERRORS_H__

#ifdef __cplusplus
extern "C" {
#endif
////////////////////////////////////////////////////////////////////////////////

#include "dm_nutypedefs.h"

////////////////////////////////////////////////////////////////////////////////

#define DM_ERROR_CAUSE_CODE_DO_NOT_PRINT       0xAA

//DM generic library errors
#define DM_CLIBRARY_ERROR_OFFSET                     128
enum
{
    // FATAL
    ERR_CLIBRARY_INVALID_CONFIG = DM_CLIBRARY_ERROR_OFFSET,  //Invalid configuration table
    ERR_CLIBRARY_STREAM_SEND_FAILED,                         // 129 Error while queueing an event
    ERR_CLIBRARY_NO_MEMORY,                                  // 130 Memory error

    // WARNINGS
    ERR_CLIBRARY_INVALID_STREAM,                             // 131 Driver called with invalid stream
    ERR_CLIBRARY_INVALID_INSTANCE,                           // 132 Driver called with invalid stream
    ERR_CLIBRARY_STABLE_CLOCK_TIMEOUT,                       // 133 Timeout waiting for internal clock to stabilize
    ERR_CLIBRARY_DELETE_LIBRARY_FAILED,                      // 134 Library delete failed
    ERR_CLIBRARY_GENERAL,                                    // 135
    ERR_CLIBRARY_VENDOR_PROGRAM_SUCCESS,                     // 136
    ERR_CLIBRARY_VENDOR_PROGRAM_FAILED,                      // 137
    ERR_CLIBRARY_SPI_XFER_FAILED,                            // 138 SPI error
    ERR_CLIBRARY_REMOVE_VIDEO_TIMEOUT,                       // 139
    ERR_CLIBRARY_REMOVE_AUDIO_TIMEOUT,                       // 140
    ERR_CLIBRARY_VENDOR_PROGRAM_PARAM_LIST_SUCCESS,          // 141
    ERR_CLIBRARY_VENDOR_PROGRAM_PARAM_LIST_FAILED,           // 142
    ERR_CLIBRARY_VALENS_PHY_ADDR_PROGRAM_FAIL,               // 143

    LAST_CLIBRARY_ERRROR
};

typedef enum
{
    DM_ERROR_LEVEL_DEBUG =                0,
    DM_ERROR_LEVEL_NOTICE =               1,
    DM_ERROR_LEVEL_WARNING =              2,
    DM_ERROR_LEVEL_ERROR =                3,
    DM_ERROR_LEVEL_FATAL =                4
}DM_ERROR_LEVEL;

typedef enum
{
    DM_ERROR_SUBSYS_OS =  1,                        //1  operating system
    DM_ERROR_SUBSYS_CNET,                           //2  Cresnet
    DM_ERROR_SUBSYS_GENERAL,                        //3  Common errors to all cards
    DM_ERROR_SUBSYS_CARD,                           //4  Card specific
    DM_ERROR_SUBSYS_STREAM,                         //5  Stream Manager
    DM_ERROR_SUBSYS_HDMITX,                         //6  HDMI transmitter
    DM_ERROR_SUBSYS_HDMIRX,                         //7  HDMI Receiver
    DM_ERROR_SUBSYS_AUDIO,                          //8  Audio
    DM_ERROR_SUBSYS_I2C_DRIVER,                     //9  low level I2c driver
    DM_ERROR_SUBSYS_SPI_DRIVER,                     //10 low level SPi driver
    DM_ERROR_SUBSYS_EDID,                           //11 EDID error
    DM_ERROR_SUBSYS_ANALOGRX,                       //12 Analog video receiver
    DM_ERROR_SUBSYS_DMNET,                          //13 DM network error
    DM_ERROR_SUBSYS_QUADSCALER,                     //14 Quad scaler error
    DM_ERROR_SUBSYS_DSPMGR,                         //15 DSP Manager error
    DM_ERROR_SUBSYS_ETHERNET,                       //16 Ethernet errors
    DM_ERROR_SUBSYS_SERIAL,                         //17 serial port errors
    DM_ERROR_SUBSYS_USB_HOST,                       //18 usb host driver errors
    DM_ERROR_SUBSYS_CP_VERIFICATION,                //19 Copy verification errors
    DM_ERROR_SUBSYS_FRONT_PANEL,                    //20
    DM_ERROR_SUBSYS_TMDS_DRIVER,                    //21
    DM_ERROR_SUBSYS_CONTROLLER,                     //22 Device is DM Controller
    DM_ERROR_SUBSYS_DVI_SWITCHER,                   //23
    DM_ERROR_SUBSYS_CPORT_EXPANDER,                 //24
    DM_ERROR_SUBSYS_CFPGA_DRIVER,                   //25
    DM_ERROR_SUBSYS_TMDS_SWITCH,                    //26
    DM_ERROR_SUBSYS_DM_TX,                          //27
    DM_ERROR_SUBSYS_DM_RX,                          //28
    DM_ERROR_SUBSYS_TMDS_REPEATER,                  //29
    DM_ERROR_SUBSYS_TMDS_EQUALIZER,                 //30
    DM_ERROR_SUBSYS_CVIDEO_TESTER,                  //31
    DM_ERROR_SUBSYS_SMI_DRIVER,                     //32
    DM_ERROR_SUBSYS_AUDIO_SWITCHER,                 //33
    DM_ERROR_SUBSYS_SYNC_CORRECTOR,                 //34
    DM_ERROR_SUBSYS_LINE_DOUBLER,                   //35
    DM_ERROR_SUBSYS_CEC,                            //36
    DM_ERROR_SUBSYS_TX300_SWITCHER,                 //37
    DM_ERROR_SUBSYS_UPLOAD,                         //38
    DM_ERROR_SUBSYS_HDMI_FIBER,                     //39
    DM_ERROR_SUBSYS_CABLE_MEASURE,                  //40
    DM_ERROR_SUBSYS_VXP_DRIVER,                     //41
    DM_ERROR_SUBSYS_SDI_RX,                         //42
    DM_ERROR_SUBSYS_VRX_DRIVER,                     //43
    DM_ERROR_SUBSYS_VALENS_TX,                      //44
    DM_ERROR_SUBSYS_VALENS_RX,                      //45
    DM_ERROR_SUBSYS_GENNUM_SCALER,                  //46
    DM_ERROR_SUBSYS_SINGLE_SCALER,                  //47
    DM_ERROR_SUBSYS_RESISTIVE_TOUCH,                //48
    DM_ERROR_SUBSYS_ANALOG_VIDEO_TX,                //49
    DM_ERROR_SUBSYS_TX400_SWITCHER,                 //50
    DM_ERROR_SUBSYS_OWLINK_RX,                      //51
    DM_ERROR_SUBSYS_OWLINK_TX,                      //52
    DM_ERROR_SUBSYS_OWLINK_COMMON,                  //53
    DM_ERROR_SUBSYS_TRS_DRIVER,                     //54
    DM_ERROR_SUBSYS_TASK_SWITCHER,                  //55
    DM_ERROR_SUBSYS_TX_EDID,                        //56
    DM_ERROR_SUBSYS_RX_EDID,                        //57
    DM_ERROR_SUBSYS_DE_GENERATOR,                   //58
    DM_ERROR_SUBSYS_HDMI_TASK_SWITCHER,             //59
    DM_ERROR_SUBSYS_EXT_UART,                       //60
    DM_ERROR_SUBSYS_OVERLAY_HANDLER,                //61
    DM_ERROR_SUBSYS_LVDS_RX,                        //62
    DM_ERROR_SUBSYS_EXT_MEMORY,                     //63
    DM_ERROR_SUBSYS_PROAMP_7X400_7X250,             //64
    DM_ERROR_SUBSYS_SWAMP_E,                        //65
    DM_ERROR_SUBSYS_LINK_LIST_FIXED_MEMORY,         //66
    DM_ERROR_SUBSYS_CCIR_GENERATOR,                 //67
    DM_ERROR_SUBSYS_SPI,                            //68
    DM_ERROR_SUBSYS_IR,                             //69
    DM_ERROR_SUBSYS_SCALER_HDCP_MANAGER,            //70
    DM_ERROR_SUBSYS_MPS_DM_AUDIO,                   //71
    DM_ERROR_SUBSYS_FIELD_CORRECTOR,                //72
    DM_ERROR_SUBSYS_DM_ENCAP_CHECKSUM_HELPER,       //73
    DM_ERROR_SUBSYS_INPUT_SWITCHER,                 //74
    DM_ERROR_SUBSYS_HDMI_COMMON,                    //75
    DM_ERROR_SUBSYS_THAL,		                    //76
    DM_ERROR_SUBSYS_VLAN,		                    //77
    DM_ERROR_SUBSYS_ADV_DRIVER,                     //78
    DM_ERROR_SUBSYS_TEMP_SENSOR,                    //79
    DM_ERROR_SUBSYS_DALI_NET,						//80
    DM_ERROR_SUBSYS_FIBER_TEST,                     //81
	DM_ERROR_SUBSYS_DISPLAYPORT_RX,					//82
    DM_ERROR_SUBSYS_MATRIX_CALIBRATION, 			//83
    DM_ERROR_SUBSYS_CAPACITIVE_TOUCH, 			    //84
    DM_ERROR_SUBSYS_IOP_POLL_MANAGER,   			//85
    DM_ERROR_SUBSYS_DM_REGISTER_ACCESS,   			//86
	DM_ERROR_SUBSYS_SII_DRIVER,						//87
	DM_ERROR_SUBSYS_LCD_MANAGER, 					//88
    DM_ERROR_SUBSYS_EDID_PRESET, 					//89
    DM_ERROR_SYBSYS_USB_DRIVER,                     //90
    DM_ERROR_SUBSYS_CTEST_GENERATOR,                //91 
    DM_ERROR_SUBSYS_PRIORITY_MANAGER,               //92
    DM_ERROR_SUBSYS_AMP,                            //93
    DM_ERROR_SUBSYS_CHANNEL_MANAGER,                //94
    MAX_DM_ERROR_SUBSYS_COUNT
}DM_ERROR_SUBSYSTEM;

////////////////////////////////////////////////////////////////////////////////

extern void DmReboot(void);
extern void DmRebootNotFatal(void);
void DmFatalOnZeroPointer(void* pTest, UINT8 subsystem, UINT8 errCode, UINT16 causeCode);
void DmSystemError(UINT8 level, UINT8 subsystem, UINT8 errCode, UINT16 causeCode);
extern INT32 NvramRebootCmd(UINT32 ignore, char * cmd);
INT32 DmPrintErrorLog(UINT32 ignore, char *cmd);
INT32 DmClearErrorLog(UINT32 ignore, char *cmd);
void DmErrorInit(UINT8 LogSize);
extern void DmErrorPrint(char* format,...);
void DmSendCyclePower(void);
void DmErrorTimerInit(void);
void DmErrorProcessAllClear( UINT8 numStreams );

// Core Errors common between all cards and not part of specific subsystem
typedef enum
{
    // Core Fatal Errors
    ERR_GENERAL_ALLOC_MEMORY,           // 0 memory allocation failed
    ERR_GENERAL_UNKOWN_INTERRUPT,       // 1 got an unhandled interrupt which we could not recover from
    // Error
    ERR_GENERAL_WRONG_CARD,             // 2 Card Id read from hardware is incorrect (extra = id read)
    ERR_GENERAL_CBUFFER_OVERFLOW,       // 3 attempted to write to full buffer
    ERR_GENERAL_CBUFFER_UNDERFLOW,      // 4 attempted to read from empty buffer
    ERR_GENERAL_EEPROM_WRITE_ERROR,     // 5 error writing to eeprom
    ERR_GENERAL_HARD_FAULT,             // 6 Hard fault exception error
    ERR_GENERAL_MEM_EXCEPTION,          // 7 Memory exception error
    ERR_GENERAL_BUS_ERROR,              // 8 Bus fault exception
    ERR_GENERAL_USAGE_FAULT,            // 9 Usage fault exception
    ERR_GENERAL_CONSOLE_TIMEOUT,        // 10 command processing timeout
    ERR_GENERAL_NVL_MAX_SIZE_ERROR,     // 11 NVL maximum size error
    ERR_GENERAL_BOOTLOADER_UPGRADE,     // 12 problem upgrading bootloader
    ERR_GENERAL_NVL_WRITE,              // 13 problem writing to NVL
    ERR_GENERAL_NVL_CORRUPT,            // 14 both sectors of NVL are bad
    ERR_GENERAL_INVALID_AUDIO_ROUTE,    // 15 invalid audio route
    ERR_GENERAL_MEMTEST_FAILURE,        // 16 Memory test failure
    ERR_GENERAL_UART_OVERFLOW,          // 17 UART overflow
    ERR_GENERAL_CONSOLE_QUEUE_TIMEOUT,        // 18 command processing timeout
    ERR_GENERAL_CONSOLE_TJI_LOCK_FAILED,      // 19 command processing timeout
    ERR_GENERAL_I2C_RECOVERY_TRIGGERED,       // 20 I2C recovery triggered
    ERR_GENERAL_CROSSPOINT_ERROR,             // 21 crosspoint error
    ERR_GENERAL_DM_MASTER_UART_RX_INT_DURING_SEND_PACKET,           // 22 DM Master error
    ERR_GENERAL_DM_MASTER_UART_RX_ERROR_INT_DURING_SEND_PACKET,     // 23 DM Master error
    ERR_GENERAL_DM_MASTER_POLL_DEVICE_UART_ERROR,                   // 24 DM Master error
    ERR_GENERAL_DM_MASTER_POLL_DEVICE_UNKNOWN_EVENT,                // 25 DM Master error
    ERR_GENERAL_NVL_SECTOR_WRITE,       // 26 Problem writing to NVL sector
    ERR_GENERAL_NVL_FLASH_FUNCS_INIT,   // 27 Initializing NVL functions with invalid pointers
    ERR_GENERAL_DM_MASTER_INVALID_TIMER_INDEX,   // 28 DM Master error invalid timer index
    ERR_GENERAL_DM_MASTER_INVALID_UART_INDEX,    // 29 DM Master error invalid UART index
    ERR_GENERAL_DM_MASTER_RECONFIGURE_ENABLE_SEMAPHORE_TIMEOUT,            // 30 DM Master error
    ERR_GENERAL_DM_MASTER_RECONFIGURE_DISABLE_SEMAPHORE_TIMEOUT,           // 31 DM Master error
    ERR_GENERAL_DM_MASTER_RECONFIGURE_STOP_POLLING_TIMEOUT,                // 32 DM Master error
    MAX_DM_GENERAL_ERRORS
}ERR_GENERAL;

#ifdef __cplusplus
}
#endif

#endif  //__DM_ERRORS_H__

